<?php

namespace VM\AdminBundle\Controller;

use Import\ApiBundle\Entity\GpwIndex;
use Import\ApiBundle\Entity\GpwSession;
use Import\ApiBundle\Entity\GpwType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use Symfony\Component\HttpFoundation\Request;
use VM\AdminBundle\Services\ApiGetter;

class QuotesController extends AbstractController
{
    /**
     * @View(serializerGroups={"quotesList"})
     */
    public function getQuotesForMarketAction(Request $request)
    {
        $response = array();

        $find_by = array('typeId'=>intval($request->query->get('gpwTypeId')));

        $allGpwIndexes = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->findBy($find_by);

        /** @var GpwIndex $GpwIndex */
        foreach($allGpwIndexes as $GpwIndex)
        {
            $typeId = $GpwIndex->getTypeId();
            if(!isset($response[$typeId]))
            {
                $response[$typeId]['data'] = $GpwIndex->getType();
                $response[$typeId]['indexes'] = array();
            }

            $twoSessionsForIndex = $this->getDoctrine()->getRepository('ImportApiBundle:GpwSession')->getLastTwoSessionsForIndexId($GpwIndex->getId());

            $response[$typeId]['indexes'][] = array(
                'data' => $GpwIndex,
                'actualSession' => isset($twoSessionsForIndex[0])?$twoSessionsForIndex[0]:false,
                'prevSession' => isset($twoSessionsForIndex[1])?$twoSessionsForIndex[1]:false
            );
        }

        foreach($response as $id => $type)
        {
            $response[$id]['indexes'] = array_values($response[$id]['indexes']);
        }

        return array_values($response);

    }

    /**
     * @View(serializerGroups={"quotesList"})
     */
    public function getGpwTypesAction()
    {
        $response = array();

        $allGpwTypes = $this->getDoctrine()->getRepository('ImportApiBundle:GpwType')->findAll();
        $gpwTypesWithIndex=array();

        foreach($allGpwTypes as $gpwType){
            /** @var GpwIndex $IndexForType */
            $IndexForType = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->findBy(array('typeId'=>$gpwType->getId()),null,1);

            if(count($IndexForType)){
                $gpwTypesWithIndex[]=$gpwType;
            }
        }

        $response['gpwTypes']=$gpwTypesWithIndex;

        return array_values($response);

    }

    /**
     * @View(serializerGroups={"quotesList"})
     */
    public function getActualAction()
    {
        $response = array();

        $allGpwIndexes = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->findAll();

        /** @var GpwIndex $GpwIndex */
        foreach($allGpwIndexes as $GpwIndex)
        {
            $typeId = $GpwIndex->getTypeId();
            if(!isset($response[$typeId]))
            {
                $response[$typeId]['data'] = $GpwIndex->getType();
                $response[$typeId]['indexes'] = array();
            }

            $twoSessionsForIndex = $this->getDoctrine()->getRepository('ImportApiBundle:GpwSession')->getLastTwoSessionsForIndexId($GpwIndex->getId());

            $response[$typeId]['indexes'][] = array(
                'data' => $GpwIndex,
                'actualSession' => isset($twoSessionsForIndex[0])?$twoSessionsForIndex[0]:false,
                'prevSession' => isset($twoSessionsForIndex[1])?$twoSessionsForIndex[1]:false
            );
        }

        foreach($response as $id => $type)
        {
            $response[$id]['indexes'] = array_values($response[$id]['indexes']);
        }

        return array_values($response);
    }

    /**
     * @View(serializerGroups={"quotesList"})
     */
    public function getActualCurrencyAction()
    {
        $currencyTypeSymbol = 'NBP';
        $response = array();
        $allGpwIndexes = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->getGpwIndexForType($currencyTypeSymbol);

        /** @var GpwIndex $GpwIndex */
        foreach($allGpwIndexes as $GpwIndex)
        {
            $response[] = array(
                'data' => $GpwIndex,
                'actualSession' => $GpwIndex->getSessions()->first(),
//                'prevSession' => $GpwIndex->getSessions()->next()
            );
        }

        return array_values($response);
    }
}
